#include <iostream>
#include <vector>
using namespace std;

int izracunaj_segmente(const vector<int>& karte) {
    int segmenti = 0;
    for (int i = 1; i < karte.size(); ++i) {
        if (karte[i] < karte[i - 1]) {
            segmenti++;
        }
    }
    return segmenti;
}

int promena_troska(const vector<int>& karte, int pozicija) {
    int promena = 0;
    if (pozicija > 0) {
        promena += (karte[pozicija] < karte[pozicija - 1]);
    }
    if (pozicija < karte.size() - 1) {
        promena += (karte[pozicija + 1] < karte[pozicija]);
    }
    return promena;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int N, Q;
    cin >> N >> Q;
    vector<int> karte(N);
    for (int i = 0; i < N; ++i) {
        cin >> karte[i];
    }

    int trosak = izracunaj_segmente(karte);
    cout << trosak << '\n';

    while (Q--) {
        int i, j;
        cin >> i >> j;
        --i; --j;

        int pre_zamene = trosak;
        pre_zamene -= promena_troska(karte, i);
        if (j != i + 1) pre_zamene -= promena_troska(karte, j);

        swap(karte[i], karte[j]);

        pre_zamene += promena_troska(karte, i);
        if (j != i + 1) pre_zamene += promena_troska(karte, j);

        trosak = pre_zamene;
        cout << trosak << '\n';
    }

    return 0;
}